//  Steven Kappes
//  MD2Model.h
//  Description: Class to load/draw models

// Algorithm for loading and animating derived from the book "OpenGL Game Programming"

#ifndef _MD2MODEL_
#define _MD2MODEL_

#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include "Triangle.h"
#include "TargaImage.h"

#include <GL/glew.h>
#include <Fl/gl.h>
#include "gl.h"
#include "glext.h"

class MD2Model
{
	public:
		GLint surfaceAttributeLoc;
		MD2Model();
		MD2Model(char * mPath, char * tPath);
		~MD2Model();

		unsigned int frameCount(void);
		void render(unsigned int frame);
		void render_ambient(std::vector<Triangle *> * triangles, unsigned int frame);
		void animate(unsigned int startFrame, unsigned int endFrame, float interpolate);
		
		//get surface information
		void getSurfaces(std::vector<Triangle*> * triangles, unsigned int frame);
		void getSurfaces(TargaImage * positionMap, TargaImage * normalMap, unsigned int frame);
		int getSurfaces(GLuint * positionMap, GLuint * normalMap,
						 GLfloat positionBuffer[256][256][4], GLfloat normalBuffer[256][256][4],
						 unsigned int frame);
	private:
		void * modelData;
		char * texPath;

		void * getHeader(FILE * filePtr);
		void * getData(FILE * filePtr, void * headerData);
		void calculateNormal(float * f1, float * f2, float * f3);
		unsigned int readInt(FILE * filePtr);
		unsigned short readShort(FILE * filePtr);
		float readFloat(FILE * filePtr);
};

void setMaterial(float val);

#endif